/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.utils;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Polygonal2DRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.regions.selector.Polygonal2DRegionSelector;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.World;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class SCRegion {
    private final Region region;
    private final org.bukkit.World world;

    public SCRegion(Region region, org.bukkit.World world) {
        this.region = region;
        this.world = world;
    }

    public boolean contains(Location loc) {
        if (!loc.getWorld().equals((Object)this.world)) {
            return false;
        }
        BlockVector3 pos = BlockVector3.at((int)loc.getBlockX(), (int)loc.getBlockY(), (int)loc.getBlockZ());
        return this.region.contains(pos);
    }

    public String serialize() {
        Region region = this.region;
        if (region instanceof CuboidRegion) {
            CuboidRegion cuboid = (CuboidRegion)region;
            return this.serializeCuboid(cuboid);
        }
        region = this.region;
        if (region instanceof Polygonal2DRegion) {
            Polygonal2DRegion poly = (Polygonal2DRegion)region;
            return this.serializePolygon(poly);
        }
        throw new IllegalStateException("Unsupported region type " + this.region.getClass().getSimpleName());
    }

    private String serializeCuboid(CuboidRegion cuboid) {
        BlockVector3 min = cuboid.getMinimumPoint();
        BlockVector3 max = cuboid.getMaximumPoint();
        return String.format("CUBOID:%d,%d,%d,%d,%d,%d", min.x(), min.y(), min.z(), max.x(), max.y(), max.z());
    }

    private String serializePolygon(Polygonal2DRegion poly) {
        int minY = poly.getMinimumY();
        int maxY = poly.getMaximumY();
        String points = poly.getPoints().stream().map(p -> p.x() + "," + p.z()).collect(Collectors.joining(","));
        return String.format("POLYGON:%d,%d,%s", minY, maxY, points);
    }

    public static SCRegion deserialize(String s, org.bukkit.World world) {
        String[] typeSplit = s.split(":", 2);
        if (typeSplit.length != 2) {
            throw new IllegalArgumentException("Invalid region string: " + s);
        }
        String type = typeSplit[0];
        String[] parts = typeSplit[1].split(",");
        if ("CUBOID".equalsIgnoreCase(type)) {
            return SCRegion.deserializeCuboid(parts, world);
        }
        if ("POLYGON".equalsIgnoreCase(type)) {
            return SCRegion.deserializePolygon(parts, world);
        }
        throw new IllegalArgumentException("Unknown region type: " + type);
    }

    private static SCRegion deserializeCuboid(String[] parts, org.bukkit.World world) {
        if (parts.length != 6) {
            throw new IllegalArgumentException("Invalid cuboid data");
        }
        if (world == null) {
            return null;
        }
        int minX = Integer.parseInt(parts[0]);
        int minY = Integer.parseInt(parts[1]);
        int minZ = Integer.parseInt(parts[2]);
        int maxX = Integer.parseInt(parts[3]);
        int maxY = Integer.parseInt(parts[4]);
        int maxZ = Integer.parseInt(parts[5]);
        World weWorld = BukkitAdapter.adapt((org.bukkit.World)world);
        BlockVector3 min = BlockVector3.at((int)minX, (int)minY, (int)minZ);
        BlockVector3 max = BlockVector3.at((int)maxX, (int)maxY, (int)maxZ);
        CuboidRegion region = new CuboidRegion(weWorld, min, max);
        return new SCRegion((Region)region, world);
    }

    private static SCRegion deserializePolygon(String[] parts, org.bukkit.World world) {
        int minY = Integer.parseInt(parts[1]);
        int maxY = Integer.parseInt(parts[2]);
        String pointsStr = parts[3];
        if (world == null) {
            return null;
        }
        World weWorld = BukkitAdapter.adapt((org.bukkit.World)world);
        ArrayList<BlockVector2> points = new ArrayList<BlockVector2>();
        for (String token : pointsStr.split(",")) {
            String[] xy = token.split(",");
            int x = Integer.parseInt(xy[0]);
            int z = Integer.parseInt(xy[1]);
            points.add(BlockVector2.at((int)x, (int)z));
        }
        Polygonal2DRegion poly = new Polygonal2DRegion(weWorld, points, minY, maxY);
        return new SCRegion((Region)poly, world);
    }

    public static SCRegion getWESelection(Player player) {
        Region region;
        BukkitPlayer wePlayer = BukkitAdapter.adapt((Player)player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get((SessionOwner)wePlayer);
        World weWorld = wePlayer.getWorld();
        try {
            region = session.getSelection(weWorld);
        }
        catch (IncompleteRegionException e) {
            return null;
        }
        if (!(region instanceof CuboidRegion) && !(region instanceof Polygonal2DRegion)) {
            return null;
        }
        return new SCRegion(region, player.getWorld());
    }

    public void setWESelection(Player player) {
        CuboidRegionSelector selector;
        BukkitPlayer wePlayer = BukkitAdapter.adapt((Player)player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get((SessionOwner)wePlayer);
        World weWorld = wePlayer.getWorld();
        Region region = this.region;
        if (region instanceof CuboidRegion) {
            CuboidRegion cuboid = (CuboidRegion)region;
            selector = new CuboidRegionSelector(weWorld, cuboid.getMinimumPoint(), cuboid.getMaximumPoint());
        } else {
            region = this.region;
            if (region instanceof Polygonal2DRegion) {
                Polygonal2DRegion poly = (Polygonal2DRegion)region;
                selector = new Polygonal2DRegionSelector(weWorld, poly.getPoints(), poly.getMinimumY(), poly.getMaximumY());
            } else {
                return;
            }
        }
        session.setRegionSelector(weWorld, (RegionSelector)selector);
        session.dispatchCUISelection((Actor)wePlayer);
    }

    private int randomBetween(int min, int max, Random random) {
        return min + random.nextInt(max - min + 1);
    }

    public Location getRandomLocation() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        BlockVector3 min = this.region.getMinimumPoint();
        BlockVector3 max = this.region.getMaximumPoint();
        int attempts = 1000;
        while (attempts-- > 0) {
            int z;
            int y;
            int x = this.randomBetween(min.x(), max.x(), random);
            BlockVector3 pos = BlockVector3.at((int)x, (int)(y = this.randomBetween(min.y(), max.y(), random)), (int)(z = this.randomBetween(min.z(), max.z(), random)));
            if (!this.region.contains(pos)) continue;
            return new Location(this.world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        }
        return null;
    }

    public boolean isCuboid() {
        return this.region instanceof CuboidRegion;
    }

    public boolean isPolygon() {
        return this.region instanceof Polygonal2DRegion;
    }

    public boolean containsPlayer(Player player) {
        if (player == null) {
            return false;
        }
        return this.contains(player.getLocation());
    }

    public List<Player> getPlayers() {
        return Bukkit.getOnlinePlayers().stream().filter(this::containsPlayer).map(p -> p).toList();
    }

    public Region getRegion() {
        return this.region;
    }

    public org.bukkit.World getWorld() {
        return this.world;
    }
}

