/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.utils;

import dev.stemcraft.api.STEMCraftAPI;
import dev.stemcraft.api.internal.InstanceHolder;
import dev.stemcraft.api.utils.STEMCraftUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.geysermc.geyser.api.GeyserApi;

public class SCPlayer
extends STEMCraftUtil {
    private static Boolean isGeyserInstalled = null;
    private static GeyserApi geyserApi = null;
    private static Map<String, String> nameCache = new HashMap<String, String>();
    private static File configFile;
    private static YamlConfiguration config;

    @Override
    public void onLoad() {
        ConfigurationSection cacheSection;
        configFile = new File(STEMCraftAPI.api().dataFolder(), "players.yml");
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
            }
            catch (IOException e) {
                SCPlayer.error("Could not create the players.yml configuration file", e, new String[0]);
            }
        }
        if ((cacheSection = (config = YamlConfiguration.loadConfiguration((File)configFile)).getConfigurationSection("players.cache")) != null) {
            for (String key : cacheSection.getKeys(false)) {
                nameCache.put(key, cacheSection.getString(key));
            }
        }
    }

    public static boolean isBedrock(Player player) {
        if (isGeyserInstalled == null) {
            if (Bukkit.getPluginManager().getPlugin("Geyser-Spigot") != null) {
                isGeyserInstalled = true;
                geyserApi = GeyserApi.api();
            }
            return false;
        }
        if (!isGeyserInstalled.booleanValue()) {
            return false;
        }
        return geyserApi.isBedrockPlayer(player.getUniqueId());
    }

    public static ItemStack getHead(Player player) {
        if (player == null) {
            return null;
        }
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)playerHead.getItemMeta();
        skullMeta.setOwningPlayer((OfflinePlayer)player);
        playerHead.setItemMeta((ItemMeta)skullMeta);
        return playerHead;
    }

    public static CompletableFuture<Void> teleport(Player player, Location location) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Bukkit.getScheduler().runTaskLater(InstanceHolder.plugin(), () -> {
            player.teleport(location);
            future.complete(null);
        }, 1L);
        return future;
    }

    public static void teleport(Player player, Location location, Runnable callback) {
        Bukkit.getScheduler().runTaskLater(InstanceHolder.plugin(), () -> {
            player.teleport(location);
            if (callback != null) {
                callback.run();
            }
        }, 1L);
    }

    public static void updateCacheName(String id, String name) {
        nameCache.put(id, name);
        config.set("players.cache." + id, (Object)name);
        try {
            config.save(configFile);
        }
        catch (IOException e) {
            SCPlayer.error("Failed to save the players configuration file", e, new String[0]);
        }
    }

    public static String name(UUID id) {
        return SCPlayer.name(String.valueOf(id));
    }

    public static String name(String id) {
        if (nameCache.containsKey(id)) {
            return nameCache.get(id);
        }
        Player player = Bukkit.getPlayer((UUID)UUID.fromString(id));
        if (player != null) {
            String name = player.getName();
            SCPlayer.updateCacheName(id, name);
            return name;
        }
        CompletableFuture<String> futureName = CompletableFuture.supplyAsync(() -> {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(id));
            return offlinePlayer.getName();
        });
        try {
            String name = futureName.get(5L, TimeUnit.SECONDS);
            if (name != null) {
                SCPlayer.updateCacheName(id, name);
            }
            return name;
        }
        catch (Exception e) {
            SCPlayer.error("Lookup player name for UUID " + id + " failed", e, new String[0]);
            return null;
        }
    }
}

