/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.utils;

import dev.stemcraft.api.utils.STEMCraftUtil;

public class SCTime
extends STEMCraftUtil {
    public static String formatDuration(long totalSeconds) {
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L || days > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L || hours > 0L || days > 0L) {
            sb.append(minutes).append("m ");
        }
        sb.append(seconds).append("s");
        return sb.toString().trim();
    }

    public static long parseDuration(String durationStr, boolean allowPermanent) {
        durationStr = durationStr.trim().toLowerCase();
        if (allowPermanent && (durationStr.equals("permanent") || durationStr.equals("perm"))) {
            return -1L;
        }
        long totalSeconds = 0L;
        StringBuilder number = new StringBuilder();
        block6: for (char c : durationStr.toCharArray()) {
            if (Character.isDigit(c)) {
                number.append(c);
                continue;
            }
            if (number.isEmpty()) {
                throw new IllegalArgumentException("Invalid duration format: " + durationStr);
            }
            long value = Long.parseLong(number.toString());
            number.setLength(0);
            switch (c) {
                case 'd': {
                    totalSeconds += value * 86400L;
                    continue block6;
                }
                case 'h': {
                    totalSeconds += value * 3600L;
                    continue block6;
                }
                case 'm': {
                    totalSeconds += value * 60L;
                    continue block6;
                }
                case 's': {
                    totalSeconds += value;
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unknown time unit: " + c);
                }
            }
        }
        if (!number.isEmpty()) {
            throw new IllegalArgumentException("Invalid duration format: " + durationStr);
        }
        return totalSeconds;
    }
}

