/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.utils;

import dev.stemcraft.api.utils.SCText;
import dev.stemcraft.api.utils.STEMCraftUtil;
import java.util.List;
import java.util.function.BiFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;

public class SCChatMenu
extends STEMCraftUtil {
    private static final int ITEMS_PER_PAGE = 8;

    public static void render(CommandSender sender, String title, String command, int page, int count, BiFunction<Integer, Integer, List<Component>> func, String noneText) {
        int start = (page - 1) * 8;
        int maxPages = (int)Math.ceil((double)count / 8.0);
        List<Component> lines = func.apply(start, 8);
        if (lines.isEmpty()) {
            SCChatMenu.error(sender, noneText, new String[0]);
            return;
        }
        sender.sendMessage(SCChatMenu.createSeparatorString((Component)Component.text((String)title, (TextColor)NamedTextColor.AQUA)));
        for (Component line : lines) {
            sender.sendMessage(line);
        }
        TextComponent prev = Component.text((String)"<<< ", (TextColor)(page <= 1 ? NamedTextColor.GRAY : NamedTextColor.GOLD));
        if (page > 1) {
            prev = prev.clickEvent(ClickEvent.runCommand((String)("/" + command + " " + (page - 1)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Previous page")));
        }
        Component pageInfo = Component.text((String)"Page ", (TextColor)NamedTextColor.YELLOW).append(Component.text((int)page, (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)(" of " + maxPages), (TextColor)NamedTextColor.YELLOW)));
        TextComponent next = Component.text((String)" >>>", (TextColor)(page >= maxPages ? NamedTextColor.GRAY : NamedTextColor.GOLD));
        if (page < maxPages) {
            next = next.clickEvent(ClickEvent.runCommand((String)("/" + command + " " + (page + 1)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Next page")));
        }
        sender.sendMessage(SCChatMenu.createSeparatorString(prev.append(pageInfo).append((Component)next)));
    }

    private static Component createSeparatorString(Component title) {
        String separator = "-";
        int maxWidth = 320;
        int titleWidth = SCText.calculatePixelWidth(title);
        int separatorWidth = SCText.calculatePixelWidth(separator);
        int paddingWidth = (maxWidth - titleWidth - 8) / 2;
        int separatorCount = paddingWidth / separatorWidth;
        String separatorStr = separator.repeat(separatorCount);
        return ((TextComponent)Component.text((String)(separatorStr + " "), (TextColor)NamedTextColor.YELLOW).append(title)).append((Component)Component.text((String)(" " + separatorStr), (TextColor)NamedTextColor.YELLOW));
    }

    public static int getPageFromArgs(List<String> args, int index, int defaultPage) {
        if (args != null && !args.isEmpty()) {
            if (index < 0 || index >= args.size()) {
                index = args.size() - 1;
            }
            try {
                int p = Integer.parseInt(args.get(index));
                if (p >= 1) {
                    return p;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultPage;
    }

    public static int getPageFromArgs(List<String> args) {
        return SCChatMenu.getPageFromArgs(args, -1, 1);
    }
}

