/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.utils;

import dev.stemcraft.api.utils.STEMCraftUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public final class SCText
extends STEMCraftUtil {
    private static final MiniMessage MM = MiniMessage.miniMessage();
    private static final LegacyComponentSerializer LEGACY = LegacyComponentSerializer.legacyAmpersand();
    private static final int DEFAULT_WIDTH = 6;
    private static Set<Character> WIDTH_2 = new HashSet<Character>(Set.of(Character.valueOf('i'), Character.valueOf('!'), Character.valueOf(';'), Character.valueOf(':'), Character.valueOf('\''), Character.valueOf(','), Character.valueOf('.'), Character.valueOf('|')));
    private static Set<Character> WIDTH_3 = new HashSet<Character>(Set.of(Character.valueOf('l'), Character.valueOf('`')));
    private static Set<Character> WIDTH_4 = new HashSet<Character>(Set.of(Character.valueOf('t'), Character.valueOf('*'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('\"'), Character.valueOf('I'), Character.valueOf(' ')));
    private static Set<Character> WIDTH_5 = new HashSet<Character>(Set.of(Character.valueOf('f'), Character.valueOf('k'), Character.valueOf('<'), Character.valueOf('>')));
    private static Set<Character> WIDTH_6 = new HashSet<Character>(Set.of(Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('j'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('^'), Character.valueOf('&'), Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('='), Character.valueOf('+'), Character.valueOf('/'), Character.valueOf('?'), Character.valueOf('\\')));
    private static Set<Character> WIDTH_7 = new HashSet<Character>(Set.of(Character.valueOf('~'), Character.valueOf('@')));

    public static String placeholders(String text, String ... values) {
        if (text == null || text.isEmpty() || values == null || values.length == 0) {
            return text;
        }
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException("Placeholder values must be in key/value pairs.");
        }
        String result = text;
        for (int i = 0; i < values.length; i += 2) {
            String key = values[i];
            String replacement = values[i + 1];
            if (key == null || key.isEmpty()) continue;
            if (replacement == null) {
                replacement = "";
            }
            if (SCText.isAllUpper(key)) {
                replacement = replacement.toUpperCase(Locale.ROOT);
            } else if (SCText.isTitleCase(key)) {
                replacement = SCText.toTitleCase(replacement);
            }
            String pattern = "(?i)\\{" + Pattern.quote(key) + "}";
            result = result.replaceAll(pattern, Matcher.quoteReplacement(replacement));
        }
        return result;
    }

    private static boolean isAllUpper(String s) {
        return s.equals(s.toUpperCase(Locale.ROOT));
    }

    private static boolean isTitleCase(String s) {
        return s.length() > 0 && Character.isUpperCase(s.charAt(0)) && s.substring(1).equals(s.substring(1).toLowerCase(Locale.ROOT));
    }

    private static String toTitleCase(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1).toLowerCase(Locale.ROOT);
    }

    public static Component colourise(String input) {
        if (input == null || input.isEmpty()) {
            return Component.empty();
        }
        if (input.indexOf(60) != -1 && input.indexOf(62) != -1) {
            return MM.deserialize((Object)input);
        }
        return LEGACY.deserialize(input);
    }

    public static String stripColour(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        return SCText.stripColour(SCText.colourise(input));
    }

    public static String stripColour(Component component) {
        if (component == null) {
            return "";
        }
        return PlainTextComponentSerializer.plainText().serialize(component);
    }

    public static int componentLength(Component text) {
        String t = LegacyComponentSerializer.legacySection().serialize(text);
        return t.replaceAll("\u00a7[0-9a-fk-or]", "").length();
    }

    public static int calculatePixelWidth(Component text) {
        return SCText.calculatePixelWidth(LegacyComponentSerializer.legacySection().serialize(text));
    }

    public static int calculatePixelWidth(String text) {
        text = text.replaceAll("\u00a7[0-9a-fk-or]", "");
        int width = 0;
        for (char c : text.toCharArray()) {
            if (WIDTH_2.contains(Character.valueOf(c))) {
                width += 2;
                continue;
            }
            if (WIDTH_3.contains(Character.valueOf(c))) {
                width += 3;
                continue;
            }
            if (WIDTH_4.contains(Character.valueOf(c))) {
                width += 4;
                continue;
            }
            if (WIDTH_5.contains(Character.valueOf(c))) {
                width += 5;
                continue;
            }
            if (WIDTH_6.contains(Character.valueOf(c))) {
                width += 6;
                continue;
            }
            if (WIDTH_7.contains(Character.valueOf(c))) {
                width += 7;
                continue;
            }
            width += 6;
        }
        return width;
    }

    public static Location stringToLocation(String s, World world) {
        String[] data = s.split(",");
        World parsedWorld = Bukkit.getWorld((String)data[0]);
        if (parsedWorld != null) {
            world = parsedWorld;
            data = Arrays.copyOfRange(data, 1, data.length);
        }
        if (world == null) {
            world = (World)Bukkit.getWorlds().getFirst();
        }
        double x = Double.parseDouble(data[0]);
        double y = Double.parseDouble(data[1]);
        double z = Double.parseDouble(data[2]);
        float yaw = data.length > 3 ? Float.parseFloat(data[3]) : 0.0f;
        float pitch = data.length > 4 ? Float.parseFloat(data[4]) : 0.0f;
        return new Location(world, x, y, z, yaw, pitch);
    }

    public static Location stringToLocation(String s) {
        return SCText.stringToLocation(s, null);
    }

    public static String locationToString(Location loc, boolean includeWorld, boolean includeYawPitch) {
        StringBuilder sb = new StringBuilder();
        if (includeWorld) {
            sb.append(loc.getWorld().getName()).append(",");
        }
        sb.append(String.format("%.2f,%.2f,%.2f", loc.getX(), loc.getY(), loc.getZ()));
        if (includeYawPitch) {
            sb.append(String.format(",%.2f,%.2f", Float.valueOf(loc.getYaw()), Float.valueOf(loc.getPitch())));
        }
        return sb.toString();
    }

    public static String toSnakeCase(String string) {
        return string.replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase();
    }

    public static String formatBytes(long bytes) {
        int unitIndex;
        if (bytes < 1024L) {
            return bytes + " B";
        }
        String[] units = new String[]{"KB", "MB", "GB", "TB", "PB"};
        double value = bytes;
        for (unitIndex = -1; value >= 1024.0 && unitIndex < units.length - 1; value /= 1024.0, ++unitIndex) {
        }
        return String.format("%.2f %s", value, units[unitIndex]);
    }

    public static long toBytes(String formatted) {
        String unit;
        int i;
        if (formatted == null || formatted.isEmpty()) {
            throw new IllegalArgumentException("Input cannot be null or empty");
        }
        String s = formatted.trim().replaceAll("\\s+", "");
        if (s.matches("\\d+")) {
            return Long.parseLong(s);
        }
        for (i = 0; i < s.length() && (Character.isDigit(s.charAt(i)) || s.charAt(i) == '.'); ++i) {
        }
        if (i == 0 || i == s.length()) {
            throw new IllegalArgumentException("Invalid formatted byte string: " + formatted);
        }
        double value = Double.parseDouble(s.substring(0, i));
        return switch (unit = s.substring(i).toUpperCase()) {
            case "B" -> (long)value;
            case "KB" -> (long)(value * 1024.0);
            case "MB" -> (long)(value * 1024.0 * 1024.0);
            case "GB" -> (long)(value * 1024.0 * 1024.0 * 1024.0);
            case "TB" -> (long)(value * 1024.0 * 1024.0 * 1024.0 * 1024.0);
            case "PB" -> (long)(value * 1024.0 * 1024.0 * 1024.0 * 1024.0 * 1024.0);
            default -> throw new IllegalArgumentException("Unknown byte unit: " + unit);
        };
    }

    public static String toString(Inventory inv) {
        ItemStack[] contents = inv.getContents();
        StringBuilder out = new StringBuilder();
        for (ItemStack item : contents) {
            if (item == null) continue;
            out.append(item.getType().name()).append(" x").append(item.getAmount()).append(", ");
        }
        if (out.isEmpty()) {
            return "(empty)";
        }
        return out.substring(0, out.length() - 2);
    }
}

