/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.commands;

import dev.stemcraft.api.commands.STEMCraftCommand;
import java.time.Duration;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public interface STEMCraftCommandContext {
    public STEMCraftCommand getCommand();

    public CommandSender getSender();

    public Player getSenderAsPlayer();

    public String getLabelUsed();

    public String getLabel();

    public List<String> args();

    public boolean isConsole();

    public boolean isPlayer();

    public boolean hasPermission(String var1);

    public String getArg(int var1, String var2);

    public String getArgsAsString(int var1, String var2);

    public Player getArgAsPlayer(int var1, CommandSender var2);

    public OfflinePlayer getArgAsOfflinePlayer(int var1, CommandSender var2);

    public Duration getArgAsDuration(int var1, Duration var2);

    default public String getArg(int index) {
        return this.getArg(index, null);
    }

    default public String getArgsAsString(int startingIndex) {
        return this.getArgsAsString(startingIndex, "");
    }

    default public String getArgsAsString() {
        return this.getArgsAsString(1, "");
    }

    default public Player getArgAsPlayer(int index) {
        return this.getArgAsPlayer(index, null);
    }

    default public Duration getArgAsDuration(int index) {
        return this.getArgAsDuration(index, null);
    }

    default public OfflinePlayer getArgAsOfflinePlayer(int index) {
        return this.getArgAsOfflinePlayer(index, null);
    }

    default public String getSenderName() {
        Player player = this.getSenderAsPlayer();
        return player == null ? "SERVER" : player.getName();
    }
}

