/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.services.punishment;

import java.time.Instant;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class PunishmentRecord {
    private final long id;
    private final UUID targetUuid;
    private final String targetName;
    private final UUID actorUuid;
    private final String actorName;
    private final String type;
    private boolean alerted;
    private final String reason;
    private final Instant createdAt;
    private final Long durationSeconds;

    public PunishmentRecord(long id, UUID targetUuid, String targetName, UUID actorUuid, String actorName, String type, boolean alerted, String reason, Instant createdAt, Long durationSeconds) {
        this.id = id;
        this.targetUuid = targetUuid;
        this.targetName = targetName;
        this.actorUuid = actorUuid;
        this.actorName = actorName;
        this.type = type;
        this.alerted = alerted;
        this.reason = reason;
        this.createdAt = createdAt;
        this.durationSeconds = durationSeconds;
    }

    public long id() {
        return this.id;
    }

    public UUID targetUuid() {
        return this.targetUuid;
    }

    public String targetName() {
        return this.targetName;
    }

    public UUID actorUuid() {
        return this.actorUuid;
    }

    public String actorName() {
        return this.actorName;
    }

    public String type() {
        return this.type;
    }

    public boolean alerted() {
        return this.alerted;
    }

    public void setAlerted() {
        this.alerted = true;
    }

    public String reason() {
        return this.reason;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Long durationSeconds() {
        return this.durationSeconds;
    }

    public boolean permanent() {
        return this.durationSeconds == null;
    }

    public boolean cancelled() {
        return this.durationSeconds == -1L;
    }

    public Instant expiresAt() {
        if (this.permanent()) {
            return null;
        }
        return this.createdAt.plusSeconds(this.durationSeconds);
    }

    public Player getPlayerIfOnline() {
        Player player = Bukkit.getPlayer((UUID)this.targetUuid);
        if (player != null && player.isOnline()) {
            return player;
        }
        return null;
    }
}

