/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.command;

import dev.stemcraft.api.command.Command;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;

public interface CommandContext {
    public Command getCommand();

    public void dispatch(String var1, List<String> var2);

    public CommandSender getSender();

    public Player getSenderAsPlayer();

    public String getLabelUsed();

    public String getLabel();

    public List<String> args();

    public List<String> rawArgs();

    public void dropArgs(int var1);

    default public void dropArg() {
        this.dropArgs(1);
    }

    public boolean hasFlag(String var1, boolean var2);

    default public boolean hasFlag(String flag) {
        return this.hasFlag(flag, false);
    }

    public String getOption(String var1, String var2);

    default public String getOption(String option) {
        return this.getOption(option, null);
    }

    public void info(String var1, Object ... var2);

    public void warn(String var1, Object ... var2);

    public void error(String var1, Object ... var2);

    public void success(String var1, Object ... var2);

    @Contract(value=" -> fail")
    default public void returnUsage() {
        this.returnError(this.getCommand().getUsage(), new Object[0]);
    }

    @Contract(value="_,_ -> fail")
    public void returnInfo(String var1, Object ... var2);

    @Contract(value="_,_ -> fail")
    public void returnWarn(String var1, Object ... var2);

    @Contract(value="_,_ -> fail")
    public void returnError(String var1, Object ... var2);

    @Contract(value="_,_ -> fail")
    public void returnSuccess(String var1, Object ... var2);

    public boolean isConsole();

    public boolean isPlayer();

    public boolean hasPermission(String var1);

    public int numArgs();

    public String getArg(int var1, String var2);

    default public String getArg(int index) {
        return this.getArg(index, null);
    }

    default public String getArgLower(int index) {
        String arg = this.getArg(index);
        return arg == null ? null : arg.toLowerCase(Locale.ROOT);
    }

    default public String getArgUpper(int index) {
        String arg = this.getArg(index);
        return arg == null ? null : arg.toUpperCase(Locale.ROOT);
    }

    public boolean getArgAsBoolean(int var1, boolean var2);

    default public boolean getArgAsBoolean(int index) {
        return this.getArgAsBoolean(index, false);
    }

    public int getArgAsInt(int var1, int var2, Integer var3, Integer var4);

    default public int getArgAsInt(int index) {
        return this.getArgAsInt(index, 0, null, null);
    }

    default public int getArgAsInt(int index, int def) {
        return this.getArgAsInt(index, def, null, null);
    }

    public float getArgAsFloat(int var1, float var2, Float var3, Float var4);

    default public float getArgAsFloat(int index) {
        return this.getArgAsFloat(index, 0.0f, null, null);
    }

    default public float getArgAsFloat(int index, float def) {
        return this.getArgAsFloat(index, def, null, null);
    }

    public double getArgAsDouble(int var1, double var2, Double var4, Double var5);

    default public double getArgAsDouble(int index) {
        return this.getArgAsDouble(index, 0.0, null, null);
    }

    default public double getArgAsDouble(int index, double def) {
        return this.getArgAsDouble(index, def, null, null);
    }

    public String getArgsAsString(int var1, String var2);

    default public String getArgsAsString(int startingIndex) {
        return this.getArgsAsString(startingIndex, "");
    }

    default public String getArgsAsString() {
        return this.getArgsAsString(1, "");
    }

    public Player getArgAsPlayer(int var1, CommandSender var2);

    default public Player getArgAsPlayer(int index) {
        return this.getArgAsPlayer(index, null);
    }

    default public Player getArgAsPlayerOrSender(int index) {
        Player player = this.getArgAsPlayer(index, null);
        if (player == null && this.isPlayer()) {
            player = this.getSenderAsPlayer();
        }
        return player;
    }

    public OfflinePlayer getArgAsOfflinePlayer(int var1, CommandSender var2);

    default public OfflinePlayer getArgAsOfflinePlayer(int index) {
        return this.getArgAsOfflinePlayer(index, null);
    }

    public Duration getArgAsDuration(int var1, Duration var2);

    default public Duration getArgAsDuration(int index) {
        return this.getArgAsDuration(index, null);
    }

    public World getArgAsWorld(int var1, World var2);

    default public World getArgAsWorld(int index) {
        return this.getArgAsWorld(index, null);
    }

    public void checkArgsNotEmpty(String var1);

    default public void checkArgsNotEmpty() {
        this.checkArgsNotEmpty("");
    }

    public void checkNotConsole(String var1);

    default public void checkNotConsole() {
        this.checkNotConsole("");
    }

    public void checkArgsSizeAtLeast(int var1, String var2);

    default public void checkArgsSizeAtLeast(int size) {
        this.checkArgsSizeAtLeast(size, "");
    }

    public void checkArgIsInt(int var1, String var2, Object ... var3);

    public void checkArgIsFloat(int var1, String var2, Object ... var3);

    public void checkArgIsDouble(int var1, String var2, Object ... var3);

    public void checkArgIsPlayer(int var1, String var2, Object ... var3);

    default public void checkArgIsPlayer(int index) {
        this.checkArgIsPlayer(index, "", "");
    }

    public void checkArgIsPlayerIfConsole(int var1, String var2, Object ... var3);

    default public void checkArgIsPlayerIfConsole(int index) {
        this.checkArgIsPlayerIfConsole(index, "", "");
    }

    public void checkArgIsOfflinePlayer(int var1, String var2, Object ... var3);

    public void checkArgIsWorld(int var1, String var2, Object ... var3);

    default public void checkArgIsWorld(int index) {
        this.checkArgIsWorld(index, "", "");
    }

    default public String getSenderName() {
        Player player = this.getSenderAsPlayer();
        return player == null ? "SERVER" : player.getName();
    }
}

