/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.integration.worldedit;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Polygonal2DRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.regions.selector.Polygonal2DRegionSelector;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.World;
import dev.stemcraft.api.model.SCRegion;
import org.bukkit.entity.Player;

public class WorldEditRegionUtil {
    public static SCRegion getWESelection(Player player) {
        Region region;
        BukkitPlayer wePlayer = BukkitAdapter.adapt((Player)player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get((SessionOwner)wePlayer);
        World weWorld = wePlayer.getWorld();
        try {
            region = session.getSelection(weWorld);
        }
        catch (IncompleteRegionException e) {
            return null;
        }
        if (!(region instanceof CuboidRegion) && !(region instanceof Polygonal2DRegion)) {
            return null;
        }
        return new SCRegion(region, player.getWorld());
    }

    public static void setWESelection(Player player, SCRegion region) {
        CuboidRegionSelector selector;
        BukkitPlayer wePlayer = BukkitAdapter.adapt((Player)player);
        Region weRegion = region.getRegion();
        LocalSession session = WorldEdit.getInstance().getSessionManager().get((SessionOwner)wePlayer);
        World weWorld = wePlayer.getWorld();
        if (weRegion instanceof CuboidRegion) {
            CuboidRegion cuboid = (CuboidRegion)weRegion;
            selector = new CuboidRegionSelector(weWorld, cuboid.getMinimumPoint(), cuboid.getMaximumPoint());
        } else if (weRegion instanceof Polygonal2DRegion) {
            Polygonal2DRegion poly = (Polygonal2DRegion)weRegion;
            selector = new Polygonal2DRegionSelector(weWorld, poly.getPoints(), poly.getMinimumY(), poly.getMaximumY());
        } else {
            return;
        }
        session.setRegionSelector(weWorld, (RegionSelector)selector);
        session.dispatchCUISelection((Actor)wePlayer);
    }
}

