/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.json;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;

public final class JsonFile {
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final Path file;
    private ObjectNode root;

    public JsonFile(Path file) {
        this.file = file;
        this.root = MAPPER.createObjectNode();
    }

    public JsonFile(File parent, String name) {
        this(parent.toPath().resolve(name));
    }

    public Path path() {
        return this.file;
    }

    public ObjectNode root() {
        return this.root;
    }

    public JsonFile load() throws IOException {
        if (!Files.exists(this.file, new LinkOption[0])) {
            this.root = MAPPER.createObjectNode();
            return this;
        }
        JsonNode n = MAPPER.readTree(this.file.toFile());
        if (n == null || n.isNull()) {
            n = MAPPER.createObjectNode();
        }
        if (!n.isObject()) {
            throw new IOException("Expected JSON object: " + String.valueOf(this.file));
        }
        this.root = (ObjectNode)n;
        return this;
    }

    public JsonFile save() throws IOException {
        Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
        MAPPER.writeValue(this.file.toFile(), (Object)this.root);
        return this;
    }

    public String getString(String ptr, String def) {
        JsonNode n = this.root.at(JsonPointer.compile((String)ptr));
        return n.isTextual() ? n.asText() : def;
    }

    public int getInt(String ptr, int def) {
        JsonNode n = this.root.at(JsonPointer.compile((String)ptr));
        return n.isInt() || n.isLong() || n.isNumber() ? n.asInt() : def;
    }

    public boolean getBoolean(String ptr, boolean def) {
        JsonNode n = this.root.at(JsonPointer.compile((String)ptr));
        return n.isBoolean() ? n.asBoolean() : def;
    }

    public JsonFile set(String ptr, String value) {
        this.setNode(ptr, (JsonNode)TextNode.valueOf((String)value));
        return this;
    }

    public JsonFile set(String ptr, int value) {
        this.setNode(ptr, (JsonNode)IntNode.valueOf((int)value));
        return this;
    }

    public JsonFile set(String ptr, boolean value) {
        this.setNode(ptr, (JsonNode)BooleanNode.valueOf((boolean)value));
        return this;
    }

    public JsonFile set(String ptr, JsonNode value) {
        this.setNode(ptr, value);
        return this;
    }

    public JsonFile remove(String ptr) {
        JsonPointer p = JsonPointer.compile((String)ptr);
        ObjectNode parent = this.ensureParentObject(p);
        parent.remove(JsonFile.unescape(p.last().toString().substring(1)));
        return this;
    }

    public JsonFile appendMap(String arrayPtr, Map<String, ?> map) {
        ArrayNode arr = this.ensureArray(arrayPtr);
        arr.add(MAPPER.valueToTree(map));
        return this;
    }

    public JsonFile appendObject(String arrayPtr, ObjectNode obj) {
        ArrayNode arr = this.ensureArray(arrayPtr);
        arr.add((JsonNode)obj);
        return this;
    }

    private void setNode(String ptr, JsonNode value) {
        JsonPointer p = JsonPointer.compile((String)ptr);
        ObjectNode parent = this.ensureParentObject(p);
        parent.set(JsonFile.unescape(p.last().toString().substring(1)), value);
    }

    private ObjectNode ensureParentObject(JsonPointer fullPtr) {
        JsonPointer parentPtr = fullPtr.head();
        JsonNode parent = this.ensureObjectPath(parentPtr);
        if (!(parent instanceof ObjectNode)) {
            throw new IllegalArgumentException("Pointer parent is not an object: " + String.valueOf(fullPtr));
        }
        ObjectNode obj = (ObjectNode)parent;
        return obj;
    }

    private ArrayNode ensureArray(String ptr) {
        String field;
        JsonPointer p = JsonPointer.compile((String)ptr);
        ObjectNode parent = this.ensureParentObject(p);
        JsonNode existing = parent.get(field = JsonFile.unescape(p.last().toString().substring(1)));
        if (existing == null || existing.isNull()) {
            ArrayNode created = MAPPER.createArrayNode();
            parent.set(field, (JsonNode)created);
            return created;
        }
        if (!existing.isArray()) {
            throw new IllegalArgumentException("Target is not an array: " + ptr);
        }
        return (ArrayNode)existing;
    }

    private JsonNode ensureObjectPath(JsonPointer ptr) {
        if (ptr == null || ptr.matches()) {
            return this.root;
        }
        ObjectNode current = this.root;
        JsonPointer p = ptr;
        while (!p.matches()) {
            if (!(current instanceof ObjectNode)) {
                throw new IllegalArgumentException("Non-object encountered while creating path: " + String.valueOf(ptr));
            }
            ObjectNode obj = current;
            String token = JsonFile.unescape(p.getMatchingProperty());
            JsonNode next = obj.get(token);
            if (next == null || next.isNull()) {
                ObjectNode created = MAPPER.createObjectNode();
                obj.set(token, (JsonNode)created);
                next = created;
            } else if (!next.isObject()) {
                throw new IllegalArgumentException("Expected object at '" + token + "': " + String.valueOf(ptr));
            }
            current = next;
            p = p.tail();
        }
        return current;
    }

    private static String unescape(String token) {
        return token.replace("~1", "/").replace("~0", "~");
    }
}

