/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.minigame.util;

import java.util.Set;

public final class ArenaStatus {
    public static final String WAITING = "waiting";
    public static final String LOADING = "loading";
    public static final String IN_GAME = "in-game";
    public static final String ENDING = "ending";
    public static final String CLEANUP = "cleanup";
    public static final String DISABLED = "disabled";
    private static final Set<String> PREDEFINED = Set.of("waiting", "loading", "in-game", "ending", "cleanup", "disabled");

    private ArenaStatus() {
    }

    public static boolean isPredefined(String status) {
        if (status == null) {
            return false;
        }
        return PREDEFINED.contains(status.toLowerCase());
    }

    public static String normalize(String status) {
        return status == null ? null : status.toLowerCase();
    }

    public static Set<String> predefined() {
        return PREDEFINED;
    }
}

