/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.minigame.util;

import java.util.Set;
import org.bukkit.Material;

public final class TeamNames {
    public static final String TEAM_ORANGE = "orange";
    public static final String TEAM_MAGENTA = "magenta";
    public static final String TEAM_LIGHT_BLUE = "light_blue";
    public static final String TEAM_YELLOW = "yellow";
    public static final String TEAM_LIME = "lime";
    public static final String TEAM_PINK = "pink";
    public static final String TEAM_GRAY = "gray";
    public static final String TEAM_LIGHT_GRAY = "light_gray";
    public static final String TEAM_CYAN = "cyan";
    public static final String TEAM_PURPLE = "purple";
    public static final String TEAM_BLUE = "blue";
    public static final String TEAM_BROWN = "brown";
    public static final String TEAM_GREEN = "green";
    public static final String TEAM_RED = "red";
    public static final String TEAM_BLACK = "black";
    public static final String TEAM_WHITE = "white";
    public static final String TEAM_AUTO = "auto";
    private static final Set<String> PREDEFINED = Set.of("orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black", "white", "auto");

    private TeamNames() {
    }

    public static boolean isPredefinedName(String name) {
        if (name == null) {
            return false;
        }
        return PREDEFINED.contains(name.toLowerCase());
    }

    public static String normalize(String name) {
        return name == null ? null : name.toLowerCase();
    }

    public static Set<String> predefined() {
        return PREDEFINED;
    }

    public static Material getMaterial(String name) {
        return switch (name.toLowerCase()) {
            case TEAM_ORANGE -> Material.ORANGE_WOOL;
            case TEAM_MAGENTA -> Material.MAGENTA_WOOL;
            case TEAM_LIGHT_BLUE -> Material.LIGHT_BLUE_WOOL;
            case TEAM_YELLOW -> Material.YELLOW_WOOL;
            case TEAM_LIME -> Material.LIME_WOOL;
            case TEAM_PINK -> Material.PINK_WOOL;
            case TEAM_GRAY -> Material.GRAY_WOOL;
            case TEAM_LIGHT_GRAY -> Material.LIGHT_GRAY_WOOL;
            case TEAM_CYAN -> Material.CYAN_WOOL;
            case TEAM_PURPLE -> Material.PURPLE_WOOL;
            case TEAM_BLUE -> Material.BLUE_WOOL;
            case TEAM_BROWN -> Material.BROWN_WOOL;
            case TEAM_GREEN -> Material.GREEN_WOOL;
            case TEAM_RED -> Material.RED_WOOL;
            case TEAM_BLACK -> Material.BLACK_WOOL;
            default -> Material.WHITE_WOOL;
        };
    }
}

