/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.model;

import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Polygonal2DRegion;
import com.sk89q.worldedit.regions.Region;
import dev.stemcraft.api.serialize.RegionSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NonNull;

public class SCRegion
implements ConfigurationSerializable {
    private final Region region;
    private World world;
    private static final int RANDOM_SAMPLES_COUNT = 32;

    public SCRegion(Region region, World world) {
        this.region = region;
        this.world = world;
    }

    public boolean contains(Location loc) {
        if (!loc.getWorld().equals((Object)this.world)) {
            return false;
        }
        BlockVector3 pos = BlockVector3.at((int)loc.getBlockX(), (int)loc.getBlockY(), (int)loc.getBlockZ());
        return this.region.contains(pos);
    }

    public boolean contains(SCRegion other) {
        BlockVector3 bMax;
        BlockVector3 bMin;
        BlockVector3 aMax;
        if (other == null) {
            return false;
        }
        if (this.world == null || other.world == null) {
            return false;
        }
        if (!this.world.equals((Object)other.world)) {
            return false;
        }
        BlockVector3 aMin = this.region.getMinimumPoint();
        if (!SCRegion.aabbContains(aMin, aMax = this.region.getMaximumPoint(), bMin = other.region.getMinimumPoint(), bMax = other.region.getMaximumPoint())) {
            return false;
        }
        for (BlockVector3 p : other.getRepresentativePoints()) {
            if (this.region.contains(p)) continue;
            return false;
        }
        return this.containsRandomSamplesFrom(other);
    }

    public boolean intersects(SCRegion other) {
        BlockVector3 bMax;
        BlockVector3 bMin;
        BlockVector3 aMax;
        if (other == null) {
            return false;
        }
        if (this.world == null || other.world == null) {
            return false;
        }
        if (!this.world.equals((Object)other.world)) {
            return false;
        }
        BlockVector3 aMin = this.region.getMinimumPoint();
        if (!SCRegion.aabbIntersects(aMin, aMax = this.region.getMaximumPoint(), bMin = other.region.getMinimumPoint(), bMax = other.region.getMaximumPoint())) {
            return false;
        }
        if (this.region instanceof CuboidRegion && other.region instanceof CuboidRegion) {
            return true;
        }
        for (BlockVector3 p : other.getRepresentativePoints()) {
            if (!this.region.contains(p)) continue;
            return true;
        }
        for (BlockVector3 p : this.getRepresentativePoints()) {
            if (!other.region.contains(p)) continue;
            return true;
        }
        return this.intersectsByRandomSampling(other);
    }

    private static boolean aabbContains(BlockVector3 aMin, BlockVector3 aMax, BlockVector3 bMin, BlockVector3 bMax) {
        return aMin.x() <= bMin.x() && aMin.y() <= bMin.y() && aMin.z() <= bMin.z() && aMax.x() >= bMax.x() && aMax.y() >= bMax.y() && aMax.z() >= bMax.z();
    }

    private static boolean aabbIntersects(BlockVector3 aMin, BlockVector3 aMax, BlockVector3 bMin, BlockVector3 bMax) {
        return aMin.x() <= bMax.x() && aMax.x() >= bMin.x() && aMin.y() <= bMax.y() && aMax.y() >= bMin.y() && aMin.z() <= bMax.z() && aMax.z() >= bMin.z();
    }

    private List<BlockVector3> getRepresentativePoints() {
        ArrayList<BlockVector3> pts = new ArrayList<BlockVector3>();
        BlockVector3 min = this.region.getMinimumPoint();
        BlockVector3 max = this.region.getMaximumPoint();
        pts.add(BlockVector3.at((int)min.x(), (int)min.y(), (int)min.z()));
        pts.add(BlockVector3.at((int)min.x(), (int)min.y(), (int)max.z()));
        pts.add(BlockVector3.at((int)min.x(), (int)max.y(), (int)min.z()));
        pts.add(BlockVector3.at((int)min.x(), (int)max.y(), (int)max.z()));
        pts.add(BlockVector3.at((int)max.x(), (int)min.y(), (int)min.z()));
        pts.add(BlockVector3.at((int)max.x(), (int)min.y(), (int)max.z()));
        pts.add(BlockVector3.at((int)max.x(), (int)max.y(), (int)min.z()));
        pts.add(BlockVector3.at((int)max.x(), (int)max.y(), (int)max.z()));
        Region region = this.region;
        if (region instanceof Polygonal2DRegion) {
            Polygonal2DRegion poly = (Polygonal2DRegion)region;
            int minY = poly.getMinimumY();
            int maxY = poly.getMaximumY();
            for (BlockVector2 p : poly.getPoints()) {
                pts.add(BlockVector3.at((int)p.x(), (int)minY, (int)p.z()));
                pts.add(BlockVector3.at((int)p.x(), (int)maxY, (int)p.z()));
            }
        }
        return pts;
    }

    private boolean containsRandomSamplesFrom(SCRegion other, int samples) {
        if (samples <= 0) {
            return true;
        }
        ThreadLocalRandom r = ThreadLocalRandom.current();
        BlockVector3 min = other.region.getMinimumPoint();
        BlockVector3 max = other.region.getMaximumPoint();
        int tries = samples * 20;
        int found = 0;
        while (tries-- > 0 && found < samples) {
            int z;
            int y;
            int x = this.randomBetween(min.x(), max.x(), r);
            BlockVector3 p = BlockVector3.at((int)x, (int)(y = this.randomBetween(min.y(), max.y(), r)), (int)(z = this.randomBetween(min.z(), max.z(), r)));
            if (!other.region.contains(p)) continue;
            ++found;
            if (this.region.contains(p)) continue;
            return false;
        }
        return true;
    }

    private boolean containsRandomSamplesFrom(SCRegion other) {
        return this.containsRandomSamplesFrom(other, 32);
    }

    private boolean intersectsByRandomSampling(SCRegion other, int samples) {
        if (samples <= 0) {
            return false;
        }
        ThreadLocalRandom r = ThreadLocalRandom.current();
        BlockVector3 aMin = this.region.getMinimumPoint();
        BlockVector3 aMax = this.region.getMaximumPoint();
        BlockVector3 bMin = other.region.getMinimumPoint();
        BlockVector3 bMax = other.region.getMaximumPoint();
        int oMinX = Math.max(aMin.x(), bMin.x());
        int oMinY = Math.max(aMin.y(), bMin.y());
        int oMinZ = Math.max(aMin.z(), bMin.z());
        int oMaxX = Math.min(aMax.x(), bMax.x());
        int oMaxY = Math.min(aMax.y(), bMax.y());
        int oMaxZ = Math.min(aMax.z(), bMax.z());
        int tries = samples * 30;
        for (int checked = 0; tries-- > 0 && checked < samples; ++checked) {
            int x = this.randomBetween(oMinX, oMaxX, r);
            int y = this.randomBetween(oMinY, oMaxY, r);
            int z = this.randomBetween(oMinZ, oMaxZ, r);
            BlockVector3 p = BlockVector3.at((int)x, (int)y, (int)z);
            if (!this.region.contains(p) || !other.region.contains(p)) continue;
            return true;
        }
        return false;
    }

    private boolean intersectsByRandomSampling(SCRegion other) {
        return this.intersectsByRandomSampling(other, 32);
    }

    private int randomBetween(int min, int max, Random random) {
        return min + random.nextInt(max - min + 1);
    }

    public Location getRandomLocation() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        BlockVector3 min = this.region.getMinimumPoint();
        BlockVector3 max = this.region.getMaximumPoint();
        int attempts = 1000;
        while (attempts-- > 0) {
            int z;
            int y;
            int x = this.randomBetween(min.x(), max.x(), random);
            BlockVector3 pos = BlockVector3.at((int)x, (int)(y = this.randomBetween(min.y(), max.y(), random)), (int)(z = this.randomBetween(min.z(), max.z(), random)));
            if (!this.region.contains(pos)) continue;
            return new Location(this.world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        }
        return null;
    }

    public Location getRandomGroundLocation() {
        for (int i = 0; i < 200; ++i) {
            int y;
            Location base = this.getRandomLocation();
            if (base == null) continue;
            World w = base.getWorld();
            int x = base.getBlockX();
            int z = base.getBlockZ();
            for (int dy = y = base.getBlockY(); dy > w.getMinHeight(); --dy) {
                Block ground = w.getBlockAt(x, dy - 1, z);
                Block feet = w.getBlockAt(x, dy, z);
                Block head = w.getBlockAt(x, dy + 1, z);
                if (!ground.getType().isSolid() || !feet.getType().isAir() || !head.getType().isAir()) continue;
                return new Location(w, (double)x + 0.5, (double)dy, (double)z + 0.5);
            }
        }
        return null;
    }

    public boolean isCuboid() {
        return this.region instanceof CuboidRegion;
    }

    public boolean isPolygon() {
        return this.region instanceof Polygonal2DRegion;
    }

    public boolean containsPlayer(Player player) {
        if (player == null) {
            return false;
        }
        return this.contains(player.getLocation());
    }

    public List<Player> getPlayers() {
        return Bukkit.getOnlinePlayers().stream().filter(this::containsPlayer).map(p -> p).toList();
    }

    public @NonNull Map<String, Object> serialize() {
        return RegionSerializer.serialize(this);
    }

    public static SCRegion deserialize(Map<String, Object> map) {
        return RegionSerializer.deserialize(map);
    }

    public String toString() {
        return RegionSerializer.toString(this);
    }

    public static SCRegion fromString(String s, World world) {
        return RegionSerializer.fromString(s, world);
    }

    public Region getRegion() {
        return this.region;
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world) {
        this.world = world;
    }
}

