/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.serialize;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Polygonal2DRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import dev.stemcraft.api.model.SCRegion;
import dev.stemcraft.api.util.MapParse;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.jspecify.annotations.NonNull;

public class RegionSerializer {
    public static @NonNull Map<String, Object> serialize(SCRegion region) {
        org.bukkit.World world = region.getWorld();
        Region worldEditRegion = region.getRegion();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("world", world != null ? world.getName() : null);
        if (worldEditRegion instanceof CuboidRegion) {
            CuboidRegion cuboid = (CuboidRegion)worldEditRegion;
            map.put("type", "CUBOID");
            map.put("min", RegionSerializer.vectorToMap(cuboid.getMinimumPoint()));
            map.put("max", RegionSerializer.vectorToMap(cuboid.getMaximumPoint()));
        } else if (worldEditRegion instanceof Polygonal2DRegion) {
            Polygonal2DRegion poly = (Polygonal2DRegion)worldEditRegion;
            map.put("type", "POLYGON");
            map.put("minY", poly.getMinimumY());
            map.put("maxY", poly.getMaximumY());
            ArrayList pts = new ArrayList();
            for (BlockVector2 p : poly.getPoints()) {
                LinkedHashMap<String, Integer> pm = new LinkedHashMap<String, Integer>();
                pm.put("x", p.x());
                pm.put("z", p.z());
                pts.add(pm);
            }
            map.put("points", pts);
        } else {
            throw new IllegalStateException("Unsupported region type " + worldEditRegion.getClass().getSimpleName());
        }
        return map;
    }

    public static SCRegion deserialize(Map<String, Object> map) throws IllegalArgumentException {
        org.bukkit.World world;
        if (map == null) {
            return null;
        }
        String worldName = MapParse.string(map, "world", "region");
        org.bukkit.World world2 = world = worldName != null ? Bukkit.getWorld((String)worldName) : null;
        if (world == null) {
            return null;
        }
        String type = MapParse.requireString(map, "type", "region");
        if ("CUBOID".equalsIgnoreCase(type)) {
            Map<String, Object> minMap = MapParse.requireMap(map, "min", "region");
            Map<String, Object> maxMap = MapParse.requireMap(map, "max", "region");
            int minX = MapParse.requireInt(minMap, "x", "region.min");
            int minY = MapParse.requireInt(minMap, "y", "region.min");
            int minZ = MapParse.requireInt(minMap, "z", "region.min");
            int maxX = MapParse.requireInt(maxMap, "x", "region.max");
            int maxY = MapParse.requireInt(maxMap, "y", "region.max");
            int maxZ = MapParse.requireInt(maxMap, "z", "region.max");
            World weWorld = BukkitAdapter.adapt((org.bukkit.World)world);
            BlockVector3 min = BlockVector3.at((int)minX, (int)minY, (int)minZ);
            BlockVector3 max = BlockVector3.at((int)maxX, (int)maxY, (int)maxZ);
            CuboidRegion region = new CuboidRegion(weWorld, min, max);
            return new SCRegion((Region)region, world);
        }
        if ("POLYGON".equalsIgnoreCase(type)) {
            int minY = MapParse.requireInt(map, "minY", "region");
            int maxY = MapParse.requireInt(map, "maxY", "region");
            List<Map<String, Object>> ptsMap = MapParse.listOfMaps(map.get("points"), "region.points");
            if (ptsMap.isEmpty()) {
                throw new IllegalArgumentException("Missing points for polygon region");
            }
            World weWorld = BukkitAdapter.adapt((org.bukkit.World)world);
            ArrayList<BlockVector2> pts = new ArrayList<BlockVector2>(ptsMap.size());
            for (int i = 0; i < ptsMap.size(); ++i) {
                Map<String, Object> pm = ptsMap.get(i);
                int x = MapParse.requireInt(pm, "x", "region.points[" + i + "]");
                int z = MapParse.requireInt(pm, "z", "region.points[" + i + "]");
                pts.add(BlockVector2.at((int)x, (int)z));
            }
            Polygonal2DRegion poly = new Polygonal2DRegion(weWorld, pts, minY, maxY);
            return new SCRegion((Region)poly, world);
        }
        throw new IllegalArgumentException("Unknown region type: " + type);
    }

    private static Map<String, Object> vectorToMap(BlockVector3 vec) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("x", vec.x());
        map.put("y", vec.y());
        map.put("z", vec.z());
        return map;
    }

    public static String toString(SCRegion region) {
        Region weRegion = region.getRegion();
        if (weRegion instanceof CuboidRegion) {
            CuboidRegion cuboid = (CuboidRegion)weRegion;
            return RegionSerializer.serializeCuboid(cuboid);
        }
        if (weRegion instanceof Polygonal2DRegion) {
            Polygonal2DRegion poly = (Polygonal2DRegion)weRegion;
            return RegionSerializer.serializePolygon(poly);
        }
        throw new IllegalStateException("Unsupported region type " + region.getClass().getSimpleName());
    }

    public static SCRegion fromString(String s, org.bukkit.World world) {
        String[] typeSplit = s.split(":", 2);
        if (typeSplit.length != 2) {
            throw new IllegalArgumentException("Invalid region string: " + s);
        }
        String type = typeSplit[0];
        String[] parts = typeSplit[1].split(",");
        if ("CUBOID".equalsIgnoreCase(type)) {
            return RegionSerializer.deserializeCuboid(parts, world);
        }
        if ("POLYGON".equalsIgnoreCase(type)) {
            return RegionSerializer.deserializePolygon(parts, world);
        }
        throw new IllegalArgumentException("Unknown region type: " + type);
    }

    private static String serializeCuboid(CuboidRegion cuboid) {
        BlockVector3 min = cuboid.getMinimumPoint();
        BlockVector3 max = cuboid.getMaximumPoint();
        return String.format("CUBOID:%d,%d,%d,%d,%d,%d", min.x(), min.y(), min.z(), max.x(), max.y(), max.z());
    }

    private static String serializePolygon(Polygonal2DRegion poly) {
        int minY = poly.getMinimumY();
        int maxY = poly.getMaximumY();
        String points = poly.getPoints().stream().map(p -> p.x() + "," + p.z()).collect(Collectors.joining(","));
        return String.format("POLYGON:%d,%d,%s", minY, maxY, points);
    }

    private static SCRegion deserializeCuboid(String[] parts, org.bukkit.World world) {
        if (parts.length != 6) {
            throw new IllegalArgumentException("Invalid cuboid data");
        }
        if (world == null) {
            return null;
        }
        int minX = Integer.parseInt(parts[0]);
        int minY = Integer.parseInt(parts[1]);
        int minZ = Integer.parseInt(parts[2]);
        int maxX = Integer.parseInt(parts[3]);
        int maxY = Integer.parseInt(parts[4]);
        int maxZ = Integer.parseInt(parts[5]);
        World weWorld = BukkitAdapter.adapt((org.bukkit.World)world);
        BlockVector3 min = BlockVector3.at((int)minX, (int)minY, (int)minZ);
        BlockVector3 max = BlockVector3.at((int)maxX, (int)maxY, (int)maxZ);
        CuboidRegion region = new CuboidRegion(weWorld, min, max);
        return new SCRegion((Region)region, world);
    }

    private static SCRegion deserializePolygon(String[] parts, org.bukkit.World world) {
        int minY = Integer.parseInt(parts[0]);
        int maxY = Integer.parseInt(parts[1]);
        if (world == null) {
            return null;
        }
        World weWorld = BukkitAdapter.adapt((org.bukkit.World)world);
        ArrayList<BlockVector2> points = new ArrayList<BlockVector2>();
        int i = 2;
        while (i + 1 < parts.length) {
            int x = Integer.parseInt(parts[i]);
            int z = Integer.parseInt(parts[i + 1]);
            points.add(BlockVector2.at((int)x, (int)z));
            i += 2;
        }
        Polygonal2DRegion poly = new Polygonal2DRegion(weWorld, points, minY, maxY);
        return new SCRegion((Region)poly, world);
    }
}

