/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.service.world;

import dev.stemcraft.api.config.ConfigSection;
import dev.stemcraft.api.service.world.WorldBaseSetting;
import dev.stemcraft.api.service.world.WorldChangeSession;
import dev.stemcraft.api.service.world.WorldGeneration;
import java.nio.file.Path;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;

public interface WorldService {
    public boolean worldExists(String var1);

    public boolean isWorldLoaded(String var1);

    public World loadWorld(String var1);

    public boolean unloadWorld(String var1, boolean var2);

    public World createWorld(String var1, String var2, String var3);

    default public World createWorld(String worldName) {
        return this.createWorld(worldName, null, null);
    }

    default public World createWorld(String worldName, String generatorName) {
        return this.createWorld(worldName, generatorName, null);
    }

    public void deleteWorld(String var1) throws Exception;

    public void renameWorld(String var1, String var2) throws Exception;

    public void duplicateWorld(String var1, String var2) throws Exception;

    public List<String> listWorlds();

    public Path getWorldFolder(String var1);

    public WorldGeneration generator();

    public void evictAllPlayers(World var1);

    default public void evictAllPlayers(String worldName) {
        World world = Bukkit.getWorld((String)worldName);
        if (world != null) {
            this.evictAllPlayers(world);
        }
    }

    public World getDefaultWorld();

    public void setDefaultWorld(World var1);

    public ConfigSection getConfigSection(World var1);

    public ConfigSection getConfigSection(String var1);

    public void registerSettingHandler(WorldBaseSetting var1, SettingCommandMode var2);

    default public void registerSettingHandler(WorldBaseSetting setting) {
        this.registerSettingHandler(setting, SettingCommandMode.FLAG);
    }

    public boolean isSettingRegistered(String var1);

    public boolean settingExists(World var1, String var2);

    public String getSetting(World var1, String var2);

    public void setSetting(World var1, String var2, String var3);

    public WorldChangeSession changes(World var1);

    public static enum SettingCommandMode {
        FLAG,
        SUBCOMMAND;

    }
}

