/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.util;

public final class ByteFormat {
    public static String formatBytes(long bytes) {
        int unitIndex;
        if (bytes < 1024L) {
            return bytes + " B";
        }
        String[] units = new String[]{"KB", "MB", "GB", "TB", "PB"};
        double value = bytes;
        for (unitIndex = -1; value >= 1024.0 && unitIndex < units.length - 1; value /= 1024.0, ++unitIndex) {
        }
        return String.format("%.2f %s", value, units[unitIndex]);
    }

    public static long toBytes(String formatted) {
        String unit;
        int i;
        if (formatted == null || formatted.isEmpty()) {
            throw new IllegalArgumentException("Input cannot be null or empty");
        }
        String s = formatted.trim().replaceAll("\\s+", "");
        if (s.matches("\\d+")) {
            return Long.parseLong(s);
        }
        for (i = 0; i < s.length() && (Character.isDigit(s.charAt(i)) || s.charAt(i) == '.'); ++i) {
        }
        if (i == 0 || i == s.length()) {
            throw new IllegalArgumentException("Invalid formatted byte string: " + formatted);
        }
        double value = Double.parseDouble(s.substring(0, i));
        return switch (unit = s.substring(i).toUpperCase()) {
            case "B" -> (long)value;
            case "KB" -> (long)(value * 1024.0);
            case "MB" -> (long)(value * 1024.0 * 1024.0);
            case "GB" -> (long)(value * 1024.0 * 1024.0 * 1024.0);
            case "TB" -> (long)(value * 1024.0 * 1024.0 * 1024.0 * 1024.0);
            case "PB" -> (long)(value * 1024.0 * 1024.0 * 1024.0 * 1024.0 * 1024.0);
            default -> throw new IllegalArgumentException("Unknown byte unit: " + unit);
        };
    }
}

