/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import org.jspecify.annotations.NonNull;

public class FileUtil {
    public static void copyFile(Path src, Path dest) throws IOException {
        Files.createDirectories(dest.getParent(), new FileAttribute[0]);
        Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
    }

    public static void copyDirectory(final Path srcDir, final Path destDir, final boolean overwrite) throws IOException {
        CopyOption[] copyOptionArray;
        if (!Files.exists(srcDir, new LinkOption[0])) {
            return;
        }
        if (overwrite) {
            CopyOption[] copyOptionArray2 = new CopyOption[2];
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[1] = StandardCopyOption.COPY_ATTRIBUTES;
        } else {
            CopyOption[] copyOptionArray3 = new CopyOption[1];
            copyOptionArray = copyOptionArray3;
            copyOptionArray3[0] = StandardCopyOption.COPY_ATTRIBUTES;
        }
        final CopyOption[] copyOptions = copyOptionArray;
        Files.walkFileTree(srcDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public @NonNull FileVisitResult preVisitDirectory(@NonNull Path dir, @NonNull BasicFileAttributes attrs) throws IOException {
                Path rel = srcDir.relativize(dir);
                Files.createDirectories(destDir.resolve(rel), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public @NonNull FileVisitResult visitFile(@NonNull Path file, @NonNull BasicFileAttributes attrs) throws IOException {
                Path rel = srcDir.relativize(file);
                Path target = destDir.resolve(rel);
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                if (!overwrite && Files.exists(target, new LinkOption[0])) {
                    return FileVisitResult.CONTINUE;
                }
                Files.copy(file, target, copyOptions);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static String sha1Hex(File file) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            try (FileInputStream in = new FileInputStream(file);){
                int read;
                byte[] buffer = new byte[8192];
                while ((read = ((InputStream)in).read(buffer)) != -1) {
                    digest.update(buffer, 0, read);
                }
            }
            byte[] hash = digest.digest();
            StringBuilder hex = new StringBuilder(hash.length * 2);
            for (byte b : hash) {
                hex.append(String.format("%02x", b));
            }
            return hex.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to compute SHA-1 for " + file.getAbsolutePath(), e);
        }
    }

    public static void deleteRecursive(File f) throws IOException {
        File[] children;
        if (!f.exists()) {
            return;
        }
        if (f.isDirectory() && (children = f.listFiles()) != null) {
            for (File c : children) {
                FileUtil.deleteRecursive(c);
            }
        }
        if (!f.delete()) {
            throw new IOException("Failed to delete " + String.valueOf(f));
        }
    }

    public long getLatestModified(File file) {
        File[] children;
        long latest = file.lastModified();
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                latest = Math.max(latest, this.getLatestModified(child));
            }
        }
        return latest;
    }
}

