/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.util;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class LocationUtil {
    private static final String DELIM = ",";

    public static Location deserialize(String serialized, World defaultWorld) {
        String[] parts = serialized.trim().split(DELIM);
        World world = defaultWorld;
        float yaw = 0.0f;
        float pitch = 0.0f;
        if (parts.length < 3) {
            return null;
        }
        int offset = 0;
        if (!LocationUtil.isNumber(parts[0])) {
            world = Bukkit.getWorld((String)parts[0]);
            if (world == null) {
                return null;
            }
            offset = 1;
        }
        double x = Double.parseDouble(parts[offset]);
        double y = Double.parseDouble(parts[offset + 1]);
        double z = Double.parseDouble(parts[offset + 2]);
        if (parts.length >= 4 + offset) {
            yaw = Float.parseFloat(parts[offset + 3]);
        }
        if (parts.length >= 5 + offset) {
            pitch = Float.parseFloat(parts[offset + 4]);
        }
        return new Location(world, x, y, z, yaw, pitch);
    }

    public static Location deserialize(String serialized) {
        return LocationUtil.deserialize(serialized, null);
    }

    public static String serialize(Location location, boolean includeWorld, boolean includePitchYaw) {
        World world;
        if (location == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (includeWorld && (world = location.getWorld()) != null) {
            sb.append(world.getName()).append(DELIM);
        }
        sb.append(location.getX()).append(DELIM).append(location.getY()).append(DELIM).append(location.getZ());
        if (includePitchYaw) {
            sb.append(DELIM).append(location.getYaw()).append(DELIM).append(location.getPitch());
        }
        return sb.toString();
    }

    private static boolean isNumber(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

