/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.util;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class MapParse {
    private MapParse() {
    }

    public static Map<String, Object> map(Object value, String path) {
        if (!(value instanceof Map)) {
            throw MapParse.typeError(path, "map", value);
        }
        Map m = (Map)value;
        for (Object k : m.keySet()) {
            if (k instanceof String) continue;
            throw new IllegalArgumentException("Expected string keys at " + path + ", got key: " + MapParse.safeType(k));
        }
        Map out = m;
        return out;
    }

    public static List<?> list(Object value, String path) {
        if (value == null) {
            return List.of();
        }
        if (!(value instanceof List)) {
            throw MapParse.typeError(path, "list", value);
        }
        List l = (List)value;
        return l;
    }

    public static List<Map<String, Object>> listOfMaps(Object value, String path) {
        List<?> l = MapParse.list(value, path);
        ArrayList<Map<String, Object>> out = new ArrayList<Map<String, Object>>(l.size());
        for (int i = 0; i < l.size(); ++i) {
            out.add(MapParse.map(l.get(i), path + "[" + i + "]"));
        }
        return out;
    }

    public static String string(Map<String, Object> map, String key, String path) {
        Object v;
        Object object = v = map == null ? null : map.get(key);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            String s = (String)v;
            return s;
        }
        throw MapParse.typeError(MapParse.pathKey(path, key), "string", v);
    }

    public static Integer integer(Map<String, Object> map, String key, String path) {
        Object v;
        Object object = v = map == null ? null : map.get(key);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                Number n = (Number)object;
                yield n.intValue();
            }
            case 1 -> {
                String s = (String)object;
                yield MapParse.parseIntString(s, MapParse.pathKey(path, key));
            }
            default -> throw MapParse.typeError(MapParse.pathKey(path, key), "number", v);
        };
    }

    public static Long longValue(Map<String, Object> map, String key, String path) {
        Object v;
        Object object = v = map == null ? null : map.get(key);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                Number n = (Number)object;
                yield n.longValue();
            }
            case 1 -> {
                String s = (String)object;
                yield MapParse.parseLongString(s, MapParse.pathKey(path, key));
            }
            default -> throw MapParse.typeError(MapParse.pathKey(path, key), "number", v);
        };
    }

    public static Double doubleValue(Map<String, Object> map, String key, String path) {
        Object v;
        Object object = v = map == null ? null : map.get(key);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                Number n = (Number)object;
                yield n.doubleValue();
            }
            case 1 -> {
                String s = (String)object;
                yield MapParse.parseDoubleString(s, MapParse.pathKey(path, key));
            }
            default -> throw MapParse.typeError(MapParse.pathKey(path, key), "number", v);
        };
    }

    public static Boolean bool(Map<String, Object> map, String key, String path) {
        Object v;
        Object object = v = map == null ? null : map.get(key);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, String.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                Boolean b;
                yield b = (Boolean)object;
            }
            case 1 -> {
                String s = (String)object;
                yield MapParse.parseBoolString(s, MapParse.pathKey(path, key));
            }
            default -> throw MapParse.typeError(MapParse.pathKey(path, key), "boolean", v);
        };
    }

    public static UUID uuid(Map<String, Object> map, String key, String path) {
        Object v;
        Object object = v = map == null ? null : map.get(key);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UUID.class, String.class}, (Object)object, n)) {
            case -1: {
                return null;
            }
            case 0: {
                UUID u = (UUID)object;
                return u;
            }
            case 1: {
                String s = (String)object;
                try {
                    return UUID.fromString(s);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Invalid UUID at " + MapParse.pathKey(path, key) + ": " + s);
                }
            }
        }
        throw MapParse.typeError(MapParse.pathKey(path, key), "uuid", v);
    }

    public static String requireString(Map<String, Object> map, String key, String path) {
        String s = MapParse.string(map, key, path);
        if (s == null) {
            throw MapParse.missingError(MapParse.pathKey(path, key));
        }
        return s;
    }

    public static int requireInt(Map<String, Object> map, String key, String path) {
        Integer i = MapParse.integer(map, key, path);
        if (i == null) {
            throw MapParse.missingError(MapParse.pathKey(path, key));
        }
        return i;
    }

    public static Map<String, Object> requireMap(Map<String, Object> map, String key, String path) {
        Object v;
        Object object = v = map == null ? null : map.get(key);
        if (v == null) {
            throw MapParse.missingError(MapParse.pathKey(path, key));
        }
        return MapParse.map(v, MapParse.pathKey(path, key));
    }

    public static List<?> requireList(Map<String, Object> map, String key, String path) {
        Object v;
        Object object = v = map == null ? null : map.get(key);
        if (v == null) {
            throw MapParse.missingError(MapParse.pathKey(path, key));
        }
        return MapParse.list(v, MapParse.pathKey(path, key));
    }

    private static IllegalArgumentException missingError(String path) {
        return new IllegalArgumentException("Missing value at " + path);
    }

    private static IllegalArgumentException typeError(String path, String expected, Object actual) {
        return new IllegalArgumentException("Expected " + expected + " at " + path + ", got " + MapParse.safeType(actual));
    }

    private static String safeType(Object o) {
        return o == null ? "null" : o.getClass().getSimpleName();
    }

    private static String pathKey(String path, String key) {
        if (path == null || path.isBlank()) {
            return key;
        }
        return path + "." + key;
    }

    private static Integer parseIntString(String s, String path) {
        try {
            return Integer.parseInt(s.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid int at " + path + ": " + s);
        }
    }

    private static Long parseLongString(String s, String path) {
        try {
            return Long.parseLong(s.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid long at " + path + ": " + s);
        }
    }

    private static Double parseDoubleString(String s, String path) {
        try {
            return Double.parseDouble(s.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid double at " + path + ": " + s);
        }
    }

    private static Boolean parseBoolString(String s, String path) {
        String t;
        return switch (t = s.trim().toLowerCase()) {
            case "true", "yes", "y", "1", "on" -> true;
            case "false", "no", "n", "0", "off" -> false;
            default -> throw new IllegalArgumentException("Invalid boolean at " + path + ": " + s);
        };
    }
}

