/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.util;

import java.util.Locale;
import java.util.regex.Pattern;

public final class NamespaceId {
    private static final Pattern PATTERN = Pattern.compile("[a-z0-9_.-]+:[a-z0-9_.-/]+");

    public static boolean isValid(String id) {
        return id != null && PATTERN.matcher(id).matches();
    }

    public static void checkValid(String id) {
        if (!NamespaceId.isValid(id)) {
            throw new IllegalArgumentException("Invalid namespaced ID: " + id);
        }
    }

    public static String of(String namespace, String key) {
        return namespace + ":" + key;
    }

    public static String normalize(String id) {
        return id.toLowerCase(Locale.ROOT);
    }

    public static String getNamespace(String id) {
        if (!NamespaceId.isValid(id)) {
            throw new IllegalArgumentException("Invalid namespaced ID: " + id);
        }
        return id.split(":", 2)[0];
    }

    public static String getPath(String id) {
        if (!NamespaceId.isValid(id)) {
            throw new IllegalArgumentException("Invalid namespaced ID: " + id);
        }
        return id.split(":", 2)[1];
    }

    public static String[] getPathSegments(String id) {
        String path = NamespaceId.getPath(id);
        return path.split("/");
    }
}

