/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.stemcraft.api.STEMCraftAPI;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.geysermc.geyser.api.GeyserApi;

public class PlayerUtil {
    private static Boolean isGeyserInstalled = null;
    private static GeyserApi geyserApi = null;
    private static final Map<UUID, String> NAME_CACHE = new ConcurrentHashMap<UUID, String>();

    public static double getMaxHealth(Player player) {
        AttributeInstance inst = player.getAttribute(Attribute.MAX_HEALTH);
        return inst != null ? inst.getValue() : 20.0;
    }

    public static void setMaxHealth(Player player) {
        player.setHealth(PlayerUtil.getMaxHealth(player));
    }

    public static ItemStack getHead(Player player) {
        if (player == null) {
            return null;
        }
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)playerHead.getItemMeta();
        skullMeta.setOwningPlayer((OfflinePlayer)player);
        playerHead.setItemMeta((ItemMeta)skullMeta);
        return playerHead;
    }

    public static void teleport(Player player, Location location) {
        CompletableFuture future = new CompletableFuture();
        STEMCraftAPI.api().tasks().nextTick(() -> {
            player.teleport(location);
            future.complete(null);
        });
    }

    public static void teleport(Player player, Location location, Runnable callback) {
        STEMCraftAPI.api().tasks().nextTick(() -> {
            player.teleport(location);
            if (callback != null) {
                callback.run();
            }
        });
    }

    public static Boolean give(Player player, ItemStack item, Boolean dropOnFail, Boolean showMessage) {
        HashMap leftover = player.getInventory().addItem(new ItemStack[]{item});
        if (!leftover.isEmpty()) {
            if (dropOnFail.booleanValue()) {
                player.getWorld().dropItemNaturally(player.getLocation(), item);
                return true;
            }
            if (showMessage.booleanValue()) {
                STEMCraftAPI.api().messages().error((CommandSender)player, "INV_NO_ROOM", new Object[0]);
            }
            return false;
        }
        return true;
    }

    public static Boolean give(Player player, ItemStack item) {
        return PlayerUtil.give(player, item, false, true);
    }

    public static boolean isBedrock(Player player) {
        if (isGeyserInstalled == null) {
            if (Bukkit.getPluginManager().getPlugin("Geyser-Spigot") != null) {
                isGeyserInstalled = true;
                geyserApi = GeyserApi.api();
            }
            return false;
        }
        if (!isGeyserInstalled.booleanValue()) {
            return false;
        }
        return geyserApi.isBedrockPlayer(player.getUniqueId());
    }

    public static String name(UUID uuid, Consumer<String> onResolved) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            String name2 = player.getName();
            if (onResolved != null) {
                onResolved.accept(name2);
            }
            return name2;
        }
        OfflinePlayer offline = Bukkit.getOfflinePlayer((UUID)uuid);
        if (offline.hasPlayedBefore()) {
            String name3 = offline.getName();
            if (onResolved != null) {
                onResolved.accept(name3);
            }
            return name3;
        }
        String cached = NAME_CACHE.get(uuid);
        if (cached != null) {
            if (onResolved != null) {
                onResolved.accept(cached);
            }
            return cached;
        }
        if (onResolved != null) {
            PlayerUtil.lookupNameFromMojang(uuid).thenAccept(name -> {
                if (name != null) {
                    NAME_CACHE.put(uuid, (String)name);
                    onResolved.accept((String)name);
                }
            });
        }
        return null;
    }

    public static String name(UUID uuid) {
        return PlayerUtil.name(uuid, null);
    }

    private static CompletableFuture<String> lookupNameFromMojang(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String id = uuid.toString().replace("-", "");
                URI uri = URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + id);
                URL url = uri.toURL();
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                if (conn.getResponseCode() != 200) {
                    return null;
                }
                try (InputStream in = conn.getInputStream();){
                    String string;
                    try (InputStreamReader reader = new InputStreamReader(in);){
                        JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        string = json.has("name") ? json.get("name").getAsString() : null;
                    }
                    return string;
                }
            }
            catch (Exception e) {
                return null;
            }
        });
    }
}

