/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.util;

import dev.stemcraft.api.util.TextUtil;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;

public final class StringUtil {
    private static final Map<String, String> IRREGULAR = Map.ofEntries(Map.entry("child", "children"), Map.entry("person", "people"), Map.entry("man", "men"), Map.entry("woman", "women"), Map.entry("mouse", "mice"), Map.entry("goose", "geese"), Map.entry("tooth", "teeth"), Map.entry("foot", "feet"));

    public static boolean isAllUpper(String s) {
        return s.equals(s.toUpperCase(Locale.ROOT));
    }

    public static boolean isTitleCase(String s) {
        return !s.isEmpty() && Character.isUpperCase(s.charAt(0)) && s.substring(1).equals(s.substring(1).toLowerCase(Locale.ROOT));
    }

    public static String toTitleCase(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1).toLowerCase(Locale.ROOT);
    }

    public static String slugify(String input) {
        if (input == null) {
            return null;
        }
        return input.trim().toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9\\s_]", "").replaceAll("\\s+", "_").replaceAll("_{2,}", "_");
    }

    public static String toSnakeCase(String string) {
        return string.replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase();
    }

    public static String[] toStrings(Object ... placeholders) {
        if (placeholders == null || placeholders.length == 0) {
            return new String[0];
        }
        String[] out = new String[placeholders.length];
        for (int i = 0; i < placeholders.length; ++i) {
            Object o = placeholders[i];
            out[i] = o == null ? "null" : String.valueOf(o);
        }
        return out;
    }

    public static String capitalize(String str, Boolean ignoreColors) {
        if (str != null && !str.isEmpty()) {
            int strLen = str.length();
            StringBuilder buffer = new StringBuilder(strLen);
            boolean capitalizeNext = true;
            for (int i = 0; i < strLen; ++i) {
                char ch = str.charAt(i);
                if (Character.isWhitespace(ch)) {
                    buffer.append(ch);
                    capitalizeNext = true;
                    continue;
                }
                if (ch == '&' && ignoreColors.booleanValue() && i + 1 < strLen && "0123456789abcdefklmnor".indexOf(str.charAt(i + 1)) != -1) {
                    buffer.append(ch).append(str.charAt(i + 1));
                    ++i;
                    continue;
                }
                if (capitalizeNext) {
                    buffer.append(Character.toTitleCase(ch));
                    capitalizeNext = false;
                    continue;
                }
                buffer.append(ch);
            }
            return buffer.toString();
        }
        return str;
    }

    public static String capitalize(String str) {
        return StringUtil.capitalize(str, false);
    }

    public static String beautify(String str) {
        return str.toLowerCase().replace("_", " ");
    }

    public static String camelToSnake(String s) {
        return s.replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase();
    }

    public static String camelToKebab(String s) {
        return s.replaceAll("([a-z])([A-Z])", "$1-$2").toLowerCase();
    }

    public static String toPlural(String text) {
        int u;
        int d;
        if (text == null || text.isBlank()) {
            return text;
        }
        int s = text.lastIndexOf(32);
        int i = Math.max(s, Math.max(d = text.lastIndexOf(45), u = text.lastIndexOf(95)));
        if (i >= 0 && i < text.length() - 1) {
            String prefix = text.substring(0, i + 1);
            String tail = text.substring(i + 1);
            return prefix + StringUtil.pluraliseWord(tail);
        }
        return StringUtil.pluraliseWord(text);
    }

    public static boolean parseBoolean(String value) {
        if (value == null) {
            return false;
        }
        String trimmed = value.trim().toLowerCase(Locale.ROOT);
        return trimmed.equals("true") || trimmed.equals("yes") || trimmed.equals("1");
    }

    public static String joinPlainText(List<Component> components, String separator) {
        if (components == null || components.isEmpty()) {
            return "";
        }
        return components.stream().map(TextUtil::stripColour).collect(Collectors.joining(separator));
    }

    private static String pluraliseWord(String word) {
        if (word.isEmpty()) {
            return word;
        }
        String lower = word.toLowerCase(Locale.ROOT);
        if (StringUtil.isLikelyPlural(lower)) {
            return word;
        }
        if (IRREGULAR.containsKey(lower)) {
            return StringUtil.matchCase(word, IRREGULAR.get(lower));
        }
        if (lower.endsWith("y") && lower.length() > 1 && !StringUtil.isVowel(lower.charAt(lower.length() - 2))) {
            return word.substring(0, word.length() - 1) + "ies";
        }
        if (lower.endsWith("s") || lower.endsWith("x") || lower.endsWith("z") || lower.endsWith("ch") || lower.endsWith("sh")) {
            return word + "es";
        }
        if (lower.endsWith("fe")) {
            return word.substring(0, word.length() - 2) + "ves";
        }
        if (lower.endsWith("f")) {
            return word.substring(0, word.length() - 1) + "ves";
        }
        return word + "s";
    }

    private static boolean isLikelyPlural(String lower) {
        return lower.endsWith("s") || IRREGULAR.containsValue(lower);
    }

    private static boolean isVowel(char c) {
        return "aeiou".indexOf(c) >= 0;
    }

    private static String matchCase(String original, String plural) {
        if (original.equals(original.toUpperCase(Locale.ROOT))) {
            return plural.toUpperCase(Locale.ROOT);
        }
        if (Character.isUpperCase(original.charAt(0))) {
            return Character.toUpperCase(plural.charAt(0)) + plural.substring(1);
        }
        return plural;
    }

    public static boolean isInteger(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String escapeJson(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

