/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.util;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;

public final class TextUtil {
    private static final MiniMessage MM = MiniMessage.miniMessage();
    private static final LegacyComponentSerializer LEGACY_AMP = LegacyComponentSerializer.legacyAmpersand();
    private static final LegacyComponentSerializer LEGACY_SECTION = LegacyComponentSerializer.legacySection();
    private static final PlainTextComponentSerializer PLAIN = PlainTextComponentSerializer.plainText();

    public static Component colourise(String input) {
        boolean hasLegacy;
        if (input == null || input.isEmpty()) {
            return Component.empty();
        }
        boolean hasAngleTag = input.indexOf(60) != -1 && input.indexOf(62) != -1;
        boolean bl = hasLegacy = input.indexOf(38) != -1 || input.indexOf(167) != -1;
        if (hasAngleTag && !hasLegacy) {
            try {
                return MM.deserialize((Object)input);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (input.indexOf(167) != -1 && input.indexOf(38) == -1) {
            return LEGACY_SECTION.deserialize(input);
        }
        return LEGACY_AMP.deserialize(input);
    }

    public static Component colourise(Component input) {
        String raw = PLAIN.serialize(input);
        return LEGACY_AMP.deserialize(raw);
    }

    public static String[] colourise(String ... inputs) {
        if (inputs == null || inputs.length == 0) {
            return new String[0];
        }
        String[] out = new String[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            out[i] = TextUtil.colouriseToSection(inputs[i]);
        }
        return out;
    }

    public static String colouriseToAmpersand(String input) {
        return LEGACY_AMP.serialize(TextUtil.colourise(input));
    }

    public static String colouriseToSection(String input) {
        return LEGACY_SECTION.serialize(TextUtil.colourise(input));
    }

    public static String stripColour(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        return TextUtil.stripColour(TextUtil.colourise(input));
    }

    public static String stripColour(Component component) {
        if (component == null) {
            return "";
        }
        return PLAIN.serialize(component);
    }

    public static int componentLength(Component text) {
        String t = LegacyComponentSerializer.legacySection().serialize(text);
        return t.replaceAll("\u00a7[0-9a-fk-or]", "").length();
    }

    public static String plain(Component c) {
        return PlainTextComponentSerializer.plainText().serialize(c);
    }

    public static String untranslateCodes(String input) {
        if (input == null) {
            return null;
        }
        return input.replace('\u00a7', '&');
    }

    public static String untranslateCodesStr(Component input) {
        if (input == null) {
            return null;
        }
        return LEGACY_SECTION.serialize(input).replace('\u00a7', '&');
    }

    public static Component untranslateCodes(Component input) {
        if (input == null) {
            return null;
        }
        return Component.text((String)LEGACY_SECTION.serialize(input).replace('\u00a7', '&'));
    }
}

