/*
 * Decompiled with CFR 0.152.
 */
package dev.stemcraft.api.util;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;

public class TimeUtil {
    public static String formatDuration(long totalSeconds, FormatStyle format) {
        String unit;
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        String dayUnit = "day";
        String hourUnit = "hour";
        String minuteUnit = format == FormatStyle.VERBOSE ? "minute" : "min";
        String secondUnit = format == FormatStyle.VERBOSE ? "second" : "sec";
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            unit = format != FormatStyle.SHORT ? (days == 1L ? " " + dayUnit + " " : " " + dayUnit + "s ") : "d ";
            sb.append(days).append(unit);
        }
        if (hours > 0L || days > 0L) {
            unit = format != FormatStyle.SHORT ? (hours == 1L ? " " + hourUnit + " " : " " + hourUnit + "s ") : "h ";
            sb.append(hours).append(unit);
        }
        if (minutes > 0L || hours > 0L || days > 0L) {
            unit = format != FormatStyle.SHORT ? (minutes == 1L ? " " + minuteUnit + " " : " " + minuteUnit + "s ") : "m ";
            sb.append(minutes).append(unit);
        }
        if (seconds > 0L) {
            unit = format != FormatStyle.SHORT ? (seconds == 1L ? " " + secondUnit + " " : " " + secondUnit + "s ") : "s ";
            sb.append(seconds).append(unit);
        }
        return sb.toString().trim();
    }

    public static String formatDuration(long totalSeconds) {
        return TimeUtil.formatDuration(totalSeconds, FormatStyle.SHORT);
    }

    public static String formatShortDuration(long totalSeconds) {
        return TimeUtil.formatDuration(totalSeconds, FormatStyle.SHORT);
    }

    public static String formatLongDuration(long totalSeconds) {
        return TimeUtil.formatDuration(totalSeconds, FormatStyle.LONG);
    }

    public static String formatFriendlyDuration(long totalSeconds) {
        return TimeUtil.formatDuration(totalSeconds, FormatStyle.VERBOSE);
    }

    public static long parseDuration(String durationStr, boolean allowPermanent) {
        durationStr = durationStr.trim().toLowerCase();
        if (allowPermanent && (durationStr.equals("permanent") || durationStr.equals("perm"))) {
            return -1L;
        }
        long totalSeconds = 0L;
        StringBuilder number = new StringBuilder();
        block6: for (char c : durationStr.toCharArray()) {
            if (Character.isDigit(c)) {
                number.append(c);
                continue;
            }
            if (number.isEmpty()) {
                throw new IllegalArgumentException("Invalid duration format: " + durationStr);
            }
            long value = Long.parseLong(number.toString());
            number.setLength(0);
            switch (c) {
                case 'd': {
                    totalSeconds += value * 86400L;
                    continue block6;
                }
                case 'h': {
                    totalSeconds += value * 3600L;
                    continue block6;
                }
                case 'm': {
                    totalSeconds += value * 60L;
                    continue block6;
                }
                case 's': {
                    totalSeconds += value;
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unknown time unit: " + c);
                }
            }
        }
        if (!number.isEmpty()) {
            throw new IllegalArgumentException("Invalid duration format: " + durationStr);
        }
        return totalSeconds;
    }

    public static long parseDuration(String durationStr) {
        return TimeUtil.parseDuration(durationStr, false);
    }

    public static String toFriendlyTime(Instant instant) {
        if (instant == null) {
            return "";
        }
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime t = LocalDateTime.ofInstant(instant, zone);
        LocalDate today = LocalDate.now(zone);
        LocalDate date = t.toLocalDate();
        if (date.equals(today)) {
            return "Today " + t.toLocalTime().format(DateTimeFormatter.ofPattern("h:mm a"));
        }
        if (date.equals(today.minusDays(1L))) {
            return "Yesterday " + t.toLocalTime().format(DateTimeFormatter.ofPattern("h:mm a"));
        }
        long daysAgo = ChronoUnit.DAYS.between(date, today);
        if (daysAgo <= 7L) {
            return daysAgo + " days ago";
        }
        return t.format(DateTimeFormatter.ofPattern("d MMM h:mm a"));
    }

    public static String toTimestamp(long epochMillis) {
        return Instant.ofEpochMilli(epochMillis).atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static long DurationToRunAtMillis(Duration duration) {
        Instant targetTime = Instant.now().plus(duration);
        return targetTime.toEpochMilli();
    }

    public static boolean validDate(String date) {
        if (date == null || date.isBlank()) {
            return false;
        }
        String s = date.trim();
        try {
            LocalDate.parse(s);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static enum FormatStyle {
        SHORT,
        LONG,
        VERBOSE;

    }
}

